#include "Config.h"
#include <stdio.h>
#include <string.h>

void LoadConfig(char *username, char *password, char *cdkey, char *server, char *homechan, char *idle, int *showidle, int *idletype){
	FILE *stream = fopen("config.txt", "r");
	char buffer[1024] = "";
	if(stream){
		while(fgets(buffer, sizeof(buffer), stream)){
			strtok(buffer, "\r\n");
			if(!strnicmp(buffer, "username=", 9))
				strcpy(username, buffer + 9);
			if(!strnicmp(buffer, "password=", 9))
				strcpy(password, buffer + 9);
			if(!strnicmp(buffer, "cdkey=", 6))
				strcpy(cdkey, buffer + 6);
			if(!strnicmp(buffer, "server=", 7))
				strcpy(server, buffer + 7);
			if(!strnicmp(buffer, "homechannel=", 12))
				strcpy(homechan, buffer + 12);
			if(!strnicmp(buffer, "idle=", 5))
				strcpy(idle, buffer + 5);
			if(!strnicmp(buffer, "showidle=", 9)){
				int a = *(int *)(buffer + 9);
				*showidle = a;
			}
			if(!strnicmp(buffer, "idletype=", 9)){
				int a = *(int *)(buffer + 9);
				*idletype = a;
			}
		}
	}
	fclose(stream);
}

void QueryConfigValue(char *value, char *buffer){
	FILE *stream = fopen("config.txt", "r");
	char cvalue[1024] = "";
	if(stream){
		while(fgets(cvalue, sizeof(cvalue), stream)){
			strtok(cvalue, "\r\n");
			if(!strnicmp(cvalue, value, strlen(value)))
				strcpy(buffer, cvalue + strlen(value) + 1);
		}
	}
	fclose(stream);
}

void WriteConfig(char *username, char *password, char *cdkey, char *server, char *homechan, char *idle, int showidle, int idletype){
	FILE *stream = fopen("config.txt", "wt");
	if(stream){
		fprintf(stream, "username=%s\n", username);
		fprintf(stream, "password=%s\n", password);
		fprintf(stream, "cdkey=%s\n", cdkey);
		fprintf(stream, "server=%s\n", server);
		fprintf(stream, "homechannel=%s\n", homechan);
		fprintf(stream, "idle=%s\n", idle);
		fprintf(stream, "showidle=%i\n", showidle);
		fprintf(stream, "idletype=%i\n", idletype);
	}
	fclose(stream);
}